`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 12/11/2023 10:14:00 PM
// Design Name: 
// Module Name: test_MARIE
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module test_MARIE(
    
    );
    
   //Testcase scenario
    `define test_legacy   0                 //legacy test for all the lab implemented instructions
    `define test_subst    1                 //simple test for SUBST
    `define test_jns      2                 //simp test for JNS
    `define test_loadI    3                 //simp test for LoadI
    `define test_loadImmi 4                 //simp test for LoadImmi
    `define test_skipCond 5                 //simp test for SkipCond
    
    parameter test_scenario = `test_legacy; //Change the desired test here
    
    // Inputs
	reg clk;
	reg rst_n;
	reg test_cond;
	reg [15:0] exp_value;
	
	// Outputs
	wire [7:0] T;
	wire [11:0] disp_pc;
	wire [15:0] disp_ir;
	wire [15:0] disp_out;
	
	//UUT
	MARIE #(.test_scenario(test_scenario)) MARIE_uut(
	   .clk(clk),
	   .rst_n(rst_n),
	   .T(T),
	   .disp_pc(disp_pc),
	   .disp_ir(disp_ir),
	   .disp_outReg(disp_out)
	);
	
	initial begin: test_block
		// Initialize Inputs
		clk = 0;
		rst_n = 0;

		// Wait 100 ns for global reset to finish
		#100;
		rst_n = 1;
		
		while(disp_ir !== 'h7000 && disp_pc!== 31) begin
		  #5;
		end
		
	    //Test passing condition
		case(test_scenario)
		  0: exp_value = 'h0014;
		  1: exp_value = 'h000A;
		  2: exp_value = 'h000A;
		  3: exp_value = 'h000A;
		  4: exp_value = 'h0652;
		  5: exp_value = 'h0002;
		endcase
		
		if(disp_out != exp_value) 
		    $fatal("OUTPUT register doesn't have the expected final value. act %h vs exp %h. Test failed!", disp_out, exp_value);
		else begin
		    $display("Test PASSED!");
		end
		
		//Watchdog condition - test enters loop
		if(disp_pc === 31)
		  $fatal("Test TIMEOUT (PC overflow)");
		 
		$finish;
	end
	
	//Time watchdog
	initial begin
	   #(1000000*2*10);    //10^6 clocks
	   $fatal("Test TIMEOUT (time overflow)");
	end
	
	always #10 clk = !clk;
endmodule
